
rm(list = ls())

library("readxl")
library("writexl")
library("dplyr")
library("stargazer")
library("AER")
options(scipen=999)

BD <- read_excel("~/a. BD.xlsx")

R <- lm(SHS0 ~ P + ID_MUNICIPIO + ID_EMPRESA + VEL_BAJ + TEC_FIBRA, data = BD)
summary(R)
R_1 <- lm(P ~ z_P + ID_MUNICIPIO + ID_EMPRESA + VEL_BAJ + TEC_FIBRA, data = BD)
summary(R_1)
R_2 <- lm(SHS0 ~ z_P + ID_MUNICIPIO + ID_EMPRESA + VEL_BAJ + TEC_FIBRA, data = BD)
summary(R_2)
R_IV <- ivreg(SHS0 ~ P + ID_MUNICIPIO + ID_EMPRESA + VEL_BAJ + TEC_FIBRA | z_P + ID_MUNICIPIO + ID_EMPRESA + VEL_BAJ + TEC_FIBRA, data = BD)
summary(R_IV, diagnostics = TRUE)

C <- as.data.frame(summary(R_IV)$coefficients[,1])
C$Variable <- rownames(C)
colnames(C) <- c("Coeficiente", "Variable")
C <- C[, c("Variable", "Coeficiente")]

BD_1 <- filter(BD, FECHA == "2024-3")
BD_1 <- select(BD_1, P, SH, FECHA, ID_MUNICIPIO, ID_EMPRESA, VEL_BAJ, TEC_FIBRA)

write_xlsx(C, "b. Coeficientes_IV.xlsx")
write_xlsx(BD_1, "Observado.xlsx")
